@extends('admin.layout.master')

@section('body')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-white font-weight-bold ">
                    <h2>{{$page_title}}</h2>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" >
                            <thead>
                            <tr>
                                <th scope="col">#TRX</th>
                                <th scope="col">Details</th>
                                <th scope="col">Amount</th>
                                <th scope="col">Remaining Balance</th>
                                <th scope="col">Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($deposits as $data)
                                <tr>
                                    <td data-label="#Trx">{{isset($data->trx) ? $data->trx : 'N/A'}}</td>
                                    <td data-label="Details">{{  isset($data->title) ? $data->title : 'N/A' }}</td>
                                    <td data-label="Amount"><strong  @if($data->type == '+') style="color: green;" @elseif($data->type == '-') style="color: red;" @endif>

                                            @if($data->type == '+') + @elseif($data->type == '-') - @endif
                                            {{isset($data->amount) ? $data->amount  : 'N/A'}}   {{ $basic->currency }}</strong></td>
                                    <td data-label="Remaining Balance">
                                        <strong>{{isset($data->main_amo) ? $data->main_amo : ''}}  {{$basic->currency}}</strong>
                                    </td>

                                    <td data-label="Time">
                                        <p><i class="fa fa-calendar"></i> {!! date(' d M, Y ', strtotime($data->created_at)) !!} &nbsp;<i class="fa fa-clock"></i> {!! date(' H:i A ', strtotime($data->created_at)) !!}  </p>
                                    </td>
                                </tr>
                            @endforeach
                            <tbody>
                        </table>

                        {!! $deposits->links() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection